class MapVoteWRI expands WRI;

var BDBMapVote MapVoteMutator;
var string MapList1[257];
var string MapList2[257];
var string MapList3[257];
var string MapList4[257];
var int MapCount;
var string PlayerName[32];
var int PlayerCount;
var bool bKickVote;
var string MapVoteResults[100];
var string KickVoteResults[100];

//var bool bDM;          *
//var bool bLMS;         |*
//var bool bTDM;         ||*
//var bool bAS;          |||*
//var bool bDOM;         ||||*
//var bool bCTF;         |||||*
//var bool bOther;       ||||||*
var string GameTypes;  //0000000
var string OtherClass;
var int VoteTimeLimit;
var int KickPercent;
var bool bUseMapList;
var bool bAutoOpen;
var int  ScoreBoardDelay;
var bool bAutoDetect;
var bool bCheckOtherGameTie;
var string ServerInfoURL;
var string MapInfoURL;
var string ReportText;
var string Mode;
var int RepeatLimit;
var string MapVoteHistoryType;
var int MidGameVotePercent;
var int MinMapCount;
var string MapPreFixOverRide;
var string PreFixSwap;
var string OtherPreFix;
var string HasStartWindow;
var bool bEntryWindows;
var bool bSortWithPreFix;
var bool bDebugMode;

replication
{
   // Variables the server should send to the client.
   reliable if( Role==ROLE_Authority )
      MapList1,MapList2,MapList3,MapList4,
      MapCount,
      PlayerName,
      PlayerCount,
      AddNewPlayer,
      RemovePlayerName,
      bKickVote,
      KickVoteResults,
      MapVoteResults,
      UpdateMapVoteResults,
      UpdateKickVoteResults,
      GameTypes,
      OtherClass,
      VoteTimeLimit,
      KickPercent,
      bUseMapList,
      bAutoOpen,
      ScoreBoardDelay,
      bAutoDetect,
      bCheckOtherGameTie,
      ServerInfoURL,
      MapInfoURL,
      SendReportText,
      Mode,
      RepeatLimit,
      MapVoteHistoryType,
      MidGameVotePercent,
      MinMapCount,
      MapPreFixOverRide,
      PreFixSwap,
      OtherPreFix,
      HasStartWindow,
      bEntryWindows,
      bSortWithPreFix,
      bDebugMode;
}

simulated function bool SetupWindow ()
{
   local int i;

   // Increase the length of time messages stay on screen
   class'SayMessagePlus'.default.Lifetime     = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;
   class'CriticalStringPlus'.default.Lifetime = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;
   class'RedSayMessagePlus'.default.Lifetime  = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;
   class'TeamSayMessagePlus'.default.Lifetime = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;
   class'StringMessagePlus'.default.Lifetime  = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;
   class'DeathMessagePlus'.default.Lifetime  = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;

   //log("WRI SetupWindow");
   if ( Super.SetupWindow() )
   {
      settimer(1,false);
   }
   else
      log("Super.SetupWindow() = false");
}

simulated function timer()
{
   local int i,MyCount,MyPlayerCount;

   //count maps that have replicated
   MyCount = 0;
   i = 1;
   While(MapList1[i] != "" && i < 256)
   {
     MyCount++;
     i++;
   }
   i = 1;
   While(MapList2[i] != "" && i < 256)
   {
     MyCount++;
     i++;
   }
   i = 1;
   While(MapList3[i] != "" && i < 256)
   {
     MyCount++;
     i++;
   }
   i = 1;
   While(MapList4[i] != "" && i < 256)
   {
     MyCount++;
     i++;
   }

   //count how many PlayerNames have replicated
   While(PlayerName[MyPlayerCount++] != "");

   if(MyCount < MapCount || MyPlayerCount < PlayerCount)
   {
      //log("settimer");
      settimer(1,false);
      return;
   }

   log("Total Maps Received = "$ MyCount);

   if(MapCount > 0)
   {
      // fill Map List-Box with map names
      //  Map Number  List
      //  ----------- ----------
      //  1   - 255   MapList1
      //  256 - 510   MapList2
      //  511 - 765   MapList3
      //  766 - 1020  MapList4

      for(i=1; i<=MapCount; i++)
      {
         if(i < 256)
           MapVoteTabWindow(TheWindow).AddMapName(MapList1[i]);
         if(i >= 256 && i < 511)
           MapVoteTabWindow(TheWindow).AddMapName(MapList2[i - 255]);
         if(i >= 511 && i < 766)
           MapVoteTabWindow(TheWindow).AddMapName(MapList3[i - 510]);
         if(i >= 766)
           MapVoteTabWindow(TheWindow).AddMapName(MapList4[i - 765]);
      }

      MapVoteTabWindow(TheWindow).UpdateAdmin(GameTypes,
                                              OtherClass,
                                              VoteTimeLimit,
                                              KickPercent,
                                              ScoreBoardDelay,
                                              bUseMapList,
                                              bAutoOpen,
                                              bKickVote,
                                              bAutoDetect,
                                              bCheckOtherGameTie,
                                              RepeatLimit,
                                              MapVoteHistoryType,
                                              MidGameVotePercent,
                                              Mode,
                                              MinMapCount,
                                              MapPreFixOverRide);

      if(Mid(GameTypes,6,1) == "1")
      {
         MapVoteTabWindow(TheWindow).MapWindow.PreFixSwap = PreFixSwap;
         MapVoteTabWindow(TheWindow).MapWindow.MapPreFixOverRide = MapPreFixOverRide;
         MapVoteTabWindow(TheWindow).MapWindow.OtherPreFix = OtherPreFix;
      }
	
      // fill player list-box with player names
      if(bKickVote)
      {
         //log("EnableKickWindow");
         MapVoteTabWindow(TheWindow).EnableKickWindow();
         for(i=0; i<PlayerCount; i++)
            MapVoteTabWindow(TheWindow).AddPlayerName(PlayerName[i]);
      }

      i=0;
      while(MapVoteResults[i] != "" && i<99)
      {
         //MapVoteTabWindow(TheWindow).MapVoteResults[i] = MapVoteResults[i];
         UpdateMapVoteResults(MapVoteResults[i],i);
         i++;
      }
      i=0;
      while(KickVoteResults[i] != "" && i<99)
      {
         //MapVoteTabWindow(TheWindow).KickVoteResults[i] = KickVoteResults[i];
         UpdateKickVoteResults(KickVoteResults[i],i);
         i++;
      }
      MapVoteTabWindow(TheWindow).MapWindow.lblMapCount.SetText(MapCount $ " Maps");
      MapVoteTabWindow(TheWindow).MapWindow.lblMode.SetText("Mode: " $ Mode);

      if(ServerInfoURL != "")
      {
         //MapVoteTabWindow(TheWindow).InfoWindow.SetInfoServerAddress(InfoServerAddress, InfoServerPort, InfoFilePath, ServerInfoFile);
         MapVoteTabWindow(TheWindow).InfoWindow.SetInfoServerAddress(ServerInfoURL, MapInfoURL);
         if(MapVoteTabWindow(TheWindow).AdminWindow != none)
            AdminWindow(MapVoteTabWindow(TheWindow).AdminWindow.ClientArea).txtServerInfoURL.SetValue(ServerInfoURL);
      }
      else
         MapVoteNavBar(MapVoteTabWindow(TheWindow).InfoWindow.VSplitter.BottomClientWindow).ServerInfoButton.bDisabled = true;

      // Enable the Report buttons
      MapVoteNavBar(MapVoteTabWindow(TheWindow).InfoWindow.VSplitter.BottomClientWindow).ReportButton1.bDisabled = false;
      MapVoteNavBar(MapVoteTabWindow(TheWindow).InfoWindow.VSplitter.BottomClientWindow).ReportButton2.bDisabled = false;

      if(MapVoteTabWindow(TheWindow).AdminWindow != none)
      {
         AdminWindow(MapVoteTabWindow(TheWindow).AdminWindow.ClientArea).cboHasStartWindow.SetValue(HasStartWindow);
         AdminWindow(MapVoteTabWindow(TheWindow).AdminWindow.ClientArea).txtMapInfoURL.SetValue(MapInfoURL);
         AdminWindow(MapVoteTabWindow(TheWindow).AdminWindow.ClientArea).cbEntryWindows.bChecked = bEntryWindows;
         AdminWindow(MapVoteTabWindow(TheWindow).AdminWindow.ClientArea).cbSortWithPreFix.bChecked = bSortWithPreFix;
         AdminWindow(MapVoteTabWindow(TheWindow).AdminWindow.ClientArea).txtPreFixSwap.SetValue(PreFixSwap);
         AdminWindow(MapVoteTabWindow(TheWindow).AdminWindow.ClientArea).cbDebugMode.bChecked = bDebugMode;
      }

      if(MapInfoURL == "")
      {
         MapVoteTabWindow(TheWindow).MapWindow.InfoButton.bDisabled = true;
         MapVoteNavBar(MapVoteTabWindow(TheWindow).InfoWindow.VSplitter.BottomClientWindow).MapInfoButton.bDisabled = true;
      }
   }
}

function GetServerConfig() // executes on server
{
   if(class'BDBMapVote304.BDBMapVote'.default.bDM)
      GameTypes = "1";
   else
      GameTypes = "0";
   if(class'BDBMapVote304.BDBMapVote'.default.bLMS)
      GameTypes = GameTypes $ "1";
   else
      GameTypes = GameTypes $ "0";
   if(class'BDBMapVote304.BDBMapVote'.default.bTDM)
      GameTypes = GameTypes $ "1";
   else
      GameTypes = GameTypes $ "0";
   if(class'BDBMapVote304.BDBMapVote'.default.bAS)
      GameTypes = GameTypes $ "1";
   else
      GameTypes = GameTypes $ "0";
   if(class'BDBMapVote304.BDBMapVote'.default.bDOM)
      GameTypes = GameTypes $ "1";
   else
      GameTypes = GameTypes $ "0";
   if(class'BDBMapVote304.BDBMapVote'.default.bCTF)
      GameTypes = GameTypes $ "1";
   else
      GameTypes = GameTypes $ "0";
   if(class'BDBMapVote304.BDBMapVote'.default.bOther)
      GameTypes = GameTypes $ "1";
   else
      GameTypes = GameTypes $ "0";
   OtherClass = class'BDBMapVote304.BDBMapVote'.default.OtherClass;
   VoteTimeLimit = class'BDBMapVote304.BDBMapVote'.default.VoteTimeLimit;
   KickPercent = class'BDBMapVote304.BDBMapVote'.default.KickPercent;
   bUseMapList = class'BDBMapVote304.BDBMapVote'.default.bUseMapList;
   bAutoOpen = class'BDBMapVote304.BDBMapVote'.default.bAutoOpen;
   bKickVote = class'BDBMapVote304.BDBMapVote'.default.bKickVote;
   ScoreBoardDelay = class'BDBMapVote304.BDBMapVote'.default.ScoreBoardDelay;
   bAutoDetect = class'BDBMapVote304.BDBMapVote'.default.bAutoDetect;
   bCheckOtherGameTie = class'BDBMapVote304.BDBMapVote'.default.bCheckOtherGameTie;
   ServerInfoURL = class'BDBMapVote304.BDBMapVote'.default.ServerInfoURL;
   MapInfoURL = class'BDBMapVote304.BDBMapVote'.default.MapInfoURL;
   Mode = class'BDBMapVote304.BDBMapVote'.default.Mode;
   RepeatLimit = class'BDBMapVote304.BDBMapVote'.default.RepeatLimit;
   MapVoteHistoryType = class'BDBMapVote304.BDBMapVote'.default.MapVoteHistoryType;
   MidGameVotePercent = class'BDBMapVote304.BDBMapVote'.default.MidGameVotePercent;
   MinMapCount = class'BDBMapVote304.BDBMapVote'.default.MinMapCount;
   MapPreFixOverRide = class'BDBMapVote304.BDBMapVote'.default.MapPreFixOverRide;
   HasStartWindow = class'BDBMapVote304.BDBMapVote'.default.HasStartWindow;
   bEntryWindows = class'BDBMapVote304.BDBMapVote'.default.bEntryWindows;
   PreFixSwap = class'BDBMapVote304.BDBMapVote'.default.PreFixSwap;
   if(MapVoteMutator.OtherGameClass != None) OtherPreFix = MapVoteMutator.OtherGameClass.default.MapPreFix;
   bSortWithPreFix = class'BDBMapVote304.BDBMapVote'.default.bSortWithPreFix;
   bDebugMode = class'BDBMapVote304.BDBMapVote'.default.bDebugMode;
}
//-------------------------------------------------------------------
simulated function AddNewPlayer(string NewPlayerName)   // executes on client
{
   if(bKickVote)
      MapVoteTabWindow(TheWindow).AddPlayerName(NewPlayerName);
}
//-------------------------------------------------------------------
simulated function RemovePlayerName(string OldPlayerName)   // executes on client
{
   if(bKickVote)
      MapVoteTabWindow(TheWindow).RemovePlayerName(OldPlayerName);
}
//-------------------------------------------------------------------
simulated function UpdateMapVoteResults(string Text,int i)
{
   MapVoteTabWindow(TheWindow).UpdateMapVoteResults(Text, i);
}
//-------------------------------------------------------------------
simulated function UpdateKickVoteResults(string Text,int i)
{
   MapVoteTabWindow(TheWindow).UpdateKickVoteResults(Text, i);
}

simulated function SendReportText(string p_ReportText)
{
   if(p_ReportText == "")
   {
      MapVoteTabWindow(TheWindow).InfoWindow.SetMOTD(ReportText);
      ReportText = "";
   }
   else
      ReportText = ReportText $ p_ReportText;
}

defaultproperties
{
    WindowClass=Class'MapVoteTabWindow'
    WinLeft=50
    WinTop=30
    WinWidth=410
    WinHeight=330
}
