class PlayerVoteListBox expands UWindowListBox;

var color TeamColor[4];

function Paint(Canvas C, float MouseX, float MouseY)
{
   C.DrawColor.r = 255;
   C.DrawColor.g = 255;
   C.DrawColor.b = 255;
   DrawStretchedTexture(C, 0, 0,WinWidth, WinHeight, Texture'UWindow.WhiteTexture');
   Super.Paint(C,MouseX,MouseY);
}

function DrawItem(Canvas C, UWindowList Item, float X, float Y, float W, float H)
{
     if(PlayerVoteListItem(Item).bSelected)
     {
          C.DrawColor.r = 0;
          C.DrawColor.g = 0;
          C.DrawColor.b = 128;
          DrawStretchedTexture(C, X, Y, W, H-1, Texture'UWindow.WhiteTexture');
          C.DrawColor.r = 255;
          C.DrawColor.g = 255;
          C.DrawColor.b = 255;
     }
     else
     {
          C.DrawColor.r = 255;
          C.DrawColor.g = 255;
          C.DrawColor.b = 255;
          DrawStretchedTexture(C, X, Y, W, H-1, Texture'UWindow.WhiteTexture');

          C.DrawColor = TeamColor[int(left(PlayerVoteListItem(Item).PlayerName,1))];

          if(left(PlayerVoteListItem(Item).PlayerName,1) == "9")
          {
             // Silver = Specator
             C.DrawColor.r = 138;
             C.DrawColor.g = 164;
             C.DrawColor.b = 166;
          }
     }

     C.Font = Root.Fonts[F_Normal];

     ClipText(C, X+2, Y, left(Mid(PlayerVoteListItem(Item).PlayerName,1),3) $ " - " $ Mid(PlayerVoteListItem(Item).PlayerName,4));
}

function KeyDown( int Key, float X, float Y )
{
   local int i;
   local UWindowListBoxItem ItemPointer;
   local PlayerPawn P;

   P = GetPlayerOwner();

   if(Key == P.EInputKey.IK_MouseWheelDown || Key == P.EInputKey.IK_Down)
   {
      if(SelectedItem != None && SelectedItem.Next != None)
      {
        SetSelectedItem(UWindowListBoxItem(SelectedItem.Next));
        MakeSelectedVisible();
      }
   }

   if(Key == P.EInputKey.IK_MouseWheelUp || Key == P.EInputKey.IK_Up)
   {
      if(SelectedItem != None && SelectedItem.Prev != None && SelectedItem.Sentinel != SelectedItem.Prev)
      {
        SetSelectedItem(UWindowListBoxItem(SelectedItem.Prev));
        MakeSelectedVisible();
      }
   }

   if(Key == P.EInputKey.IK_PageDown)
   {
      if(SelectedItem != None)
      {
        ItemPointer = SelectedItem;
        for(i=0;i<7;i++)
        {
           if(ItemPointer.Next == None)
              return;
           ItemPointer = UWindowListBoxItem(ItemPointer.Next);
        }
        SetSelectedItem(ItemPointer);
        MakeSelectedVisible();
      }
   }

   if(Key == P.EInputKey.IK_PageUp)
   {
      if(SelectedItem != None)
      {
        ItemPointer = SelectedItem;
        for(i=0;i<7;i++)
        {
           if(ItemPointer.Prev == None || ItemPointer.Prev == SelectedItem.Sentinel)
              return;
           ItemPointer = UWindowListBoxItem(ItemPointer.Prev);
        }
        SetSelectedItem(ItemPointer);
        MakeSelectedVisible();
      }
   }
   ParentWindow.KeyDown(Key,X,Y);
}

function SelectPlayer(string PlayerName)
{
   local PlayerVoteListItem PlayerItem;
   local string PlayerID;

   PlayerID = left(PlayerName,3);

   for(PlayerItem=PlayerVoteListItem(Items); PlayerItem!=None; PlayerItem=PlayerVoteListItem(PlayerItem.Next) )
   {
      if(PlayerID == right(left(PlayerItem.PlayerName,4),3))
      {
         SetSelectedItem(PlayerItem);
         MakeSelectedVisible();
         break;
      }
   }
}

function DoubleClickItem(UWindowListBoxItem I)
{
   UWindowDialogClientWindow(ParentWindow).Notify(self,DE_DoubleClick);
}


defaultproperties
{
    TeamColor(0)=(R=255, G=0, B=0, A=0)
    TeamColor(1)=(R=0, G=0, B=255, A=0)
    TeamColor(2)=(R=0, G=255, B=0, A=0)
    TeamColor(3)=(R=255, G=255, B=0, A=0)
    ItemHeight=12.00
    ListClass=Class'PlayerVoteListItem'
}
