class MVWelcomeWRI expands WRI;

var string ServerInfoURL;
var string MapInfoURL;
var bool bHasStartWindow;

replication
{
   // Variables the server should send to the client.
   reliable if( Role==ROLE_Authority )
      ServerInfoURL,
      MapInfoURL,
      bHasStartWindow;
}

simulated function bool SetupWindow ()
{
   local int i;
   local WindowConsole C;

   // Increase the length of time messages stay on screen
   class'SayMessagePlus'.default.Lifetime     = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;
   class'CriticalStringPlus'.default.Lifetime = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;
   class'RedSayMessagePlus'.default.Lifetime  = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;
   class'TeamSayMessagePlus'.default.Lifetime = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;
   class'StringMessagePlus'.default.Lifetime  = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;
   class'DeathMessagePlus'.default.Lifetime  = class'BDBMapVote304.BDBMapVote'.default.MsgTimeOut;

   //log("WRI SetupWindow");
   if(ServerInfoURL != "" && class'BDBMapVote304.MapVoteNavBar'.default.bShowWelcomeWindow)
   {  // Open Welcome Window
      if ( Super.SetupWindow() )
      {
         settimer(1,false);
      }
      else
         log("Super.SetupWindow() = false");
   }
   else
   {
      settimer(1,false);
   }
}

simulated function timer()
{
  local WindowConsole C;
  local UWindowWindow KeyBinderWindow,Child;
  local bool bHotKeyBound;

  if(ServerInfoURL != "" && class'BDBMapVote304.MapVoteNavBar'.default.bShowWelcomeWindow)
  {  // SetUp Welcome Window
     MVWelcomeWindow(TheWindow).bHasStartWindow = bHasStartWindow;
     ServerInfoWindow(TheWindow.FirstChildWindow).SetInfoServerAddress(ServerInfoURL, MapInfoURL);
     ServerInfoWindow(TheWindow.FirstChildWindow).BrowseWebPage(ServerInfoURL);
  }

  C = WindowConsole(PlayerPawn(Owner).Player.Console);

  //if(class'BDBMapVote304.MVKeyBinderClientWindow'.default.bShowKeyBinder)
  bHotKeyBound = HotKeyBound();

  if( !bHotKeyBound )
  {  // Open KeyBinder Window
     KeyBinderWindow = C.Root.CreateWindow(class'BDBMapVote304.MVKeyBinderFrameWindow', 0, 0, 480, 240);
     MVKeyBinderFrameWindow(KeyBinderWindow).bHasStartWindow = bHasStartWindow;
     KeyBinderWindow.bLeaveOnScreen = True;
     KeyBinderWindow.ShowWindow();
  }

  // If No windows were opened
  if((ServerInfoURL=="" || !class'BDBMapVote304.MapVoteNavBar'.default.bShowWelcomeWindow) && bHotKeyBound) // && !class'BDBMapVote301.MVKeyBinderClientWindow'.default.bShowKeyBinder)
  {
      if(bHasStartWindow)
         FocusStartWindow();  //  Find and set focus on Mod Start Window
      else
         C.CloseUWindow(); // remove the mouse pointer
  }
  DestroyWRI();
}

function GetServerConfig() // executes on server
{
   ServerInfoURL = class'BDBMapVote304.BDBMapVote'.default.ServerInfoURL;
   MapInfoURL = class'BDBMapVote304.BDBMapVote'.default.MapInfoURL;
}

simulated function FocusStartWindow()
{
   local UWindowWindow Child;
   local WindowConsole C;

   log("FocusStartWindow");

   C = WindowConsole(PlayerPawn(Owner).Player.Console);

   for(Child = C.Root.LastChildWindow; Child != None; Child = Child.PrevSiblingWindow)
   {
      if(left(string(Child.Class),6) == "UTMenu" || left(string(Child.Class),5) == "UMenu")
         C.CloseUWindow();
      else
         if(Child.Class != Self.Class)
            break;
   }

   if(Child == None)
      C.CloseUWindow(); // remove the mouse pointer
   else
   {
      Child.bLeaveOnScreen = True;
      Child.FocusWindow();
      Child.ShowWindow();
   }
}

simulated function bool HotKeyBound()
{
   local int I;
   local string KeyName;
   local string Alias;

   for (I=0; I<255; I++)
   {
      KeyName = PlayerPawn(Owner).ConsoleCommand( "KEYNAME "$i );
      if(KeyName != "")
      {
         Alias = PlayerPawn(Owner).ConsoleCommand( "KEYBINDING "$KeyName );
         if(Caps(Alias) == "MUTATE BDBMAPVOTE VOTEMENU")
            return true;
      }
   }
   return false;
}

defaultproperties
{
    WindowClass=Class'MVWelcomeWindow'
    WinLeft=50
    WinTop=30
    WinWidth=405
    WinHeight=345
}
