class MapVoteClientWindow expands UWindowPageWindow;

var MapVoteListBox MapListBox;
var UWindowSmallButton CloseButton;
var UWindowSmallButton VoteButton;
var UWindowSmallButton InfoButton;
var PlayerVoteListBox PlayerListBox;
var UWindowSmallButton KickVoteButton;
var MapStatusListBox lstMapStatus;
var KickStatusListBox lstKickStatus;
var UWindowCheckBox   cbLoadScreenShot;
var UMenuLabelControl lblStatusTitles;
var UMenuLabelControl lblMapCount;
var UWindowEditControl txtFind;
var UWindowSmallButton SendButton;
var UWindowEditControl txtMessage;
var UMenuLabelControl lblMode;

var Texture Screenshot;
var string MapTitle;
var string MapAuthor;
var string IdealPlayerCount;
var float LastVoteTime;
var float SelectionTime;

var string OtherPreFix,MapPreFixOverRide,PreFixSwap;

function Created()
{
   local color TextColor;
   TextColor.R = 255;
   TextColor.G = 255;
   TextColor.B = 255;

   //MapCount = 1;

   Super.Created();

   MapListBox = MapVoteListBox(CreateControl(class'MapVoteListBox',10,10,130,110));
   MapListBox.Items.Clear();

   VoteButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',50,120,40,20));
   VoteButton.DownSound = sound 'UnrealShare.BeltSnd';
   VoteButton.Text= "Vote";
   VoteButton.bDisabled = false;

   InfoButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',185,120,40,15));
   InfoButton.Text= "Info";
   InfoButton.bDisabled = false;

   PlayerListBox = PlayerVoteListBox(CreateControl(class'PlayerVoteListBox',270,10,130,110));
   PlayerListBox.Items.Clear();

   KickVoteButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',310,120,40,20));
   KickVoteButton.DownSound = sound 'UnrealShare.BeltSnd';
   KickVoteButton.Text= "Kick";
   KickVoteButton.bDisabled = true;

   lstMapStatus = MapStatusListBox(CreateControl(class'MapStatusListBox',10,150,200,130));
   lstMapStatus.bAcceptsFocus = False;
   lstMapStatus.Items.Clear();

   lstKickStatus = KickStatusListBox(CreateControl(class'KickStatusListBox',230,150,170,130));
   lstKickStatus.bAcceptsFocus = False;
   lstKickStatus.Items.Clear();

   cbLoadScreenShot = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 230, 120, 70, 20));
   cbLoadScreenShot.SetText("ScreenShot");
   cbLoadScreenShot.Align = TA_Right;
   cbLoadScreenShot.SetFont(F_Normal);
   cbLoadScreenShot.SetTextColor(TextColor);
   cbLoadScreenShot.bChecked = class'BDBMapVote304.BDBMapVote'.default.bLoadScreenShot;

   lblStatusTitles = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 10, 140, 390, 10));
   lblStatusTitles.SetText("Rank Map Name                              Votes            Player Name                         Votes");
   lblStatusTitles.SetFont(F_Normal);
   lblStatusTitles.SetTextColor(TextColor);

   lblMapCount = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 95, 120, 70, 10));
   lblMapCount.SetText("");
   lblMapCount.SetFont(F_Normal);
   lblMapCount.SetTextColor(TextColor);

   txtFind = UWindowEditControl(CreateControl(class'UWindowEditControl', -30, 120, 80, 10));
   txtFind.SetNumericOnly(false);
   txtFind.SetText("");

   txtMessage = UWindowEditControl(CreateControl(class'UWindowEditControl', -150, 285, 320, 10));
   txtMessage.SetText("");
   txtMessage.SetNumericOnly(false);
   txtMessage.SetHistory(true);
   txtMessage.SetMaxLength(150);

   SendButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 170, 285, 30, 10));
   SendButton.Text= "Send";
   SendButton.bDisabled = false;

   lblMode = UMenuLabelControl(CreateControl(class'UMenuLabelControl', 210, 290, 100, 20));
   lblMode.SetText("Mode:");
   lblMode.SetFont(F_Normal);
   lblMode.SetTextColor(TextColor);

   CloseButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton',360,285,40,20));
   CloseButton.DownSound = sound 'UnrealShare.WeaponPickup';
   CloseButton.Text= "Close";
   CloseButton.bDisabled = false;
}

function Notify(UWindowDialogControl C, byte E)
{
   Super.Notify(C,E);

   switch(E)
   {
      case DE_Change:
         switch(C)
         {
            case txtFind:
               MapListBox.Find(txtFind.GetValue());
               break;
         }
         break;

      case DE_DoubleClick:
         switch(C)
         {
            case MapListBox:
               //log("DoubleClick MapListBox");
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5) // prevent spamming
               {
	               if(Left(UMenuMapVoteList(MapListBox.SelectedItem).MapName,3) != "[X]" || GetPlayerOwner().PlayerReplicationInfo.bAdmin)
		            {
                     GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP "$UMenuMapVoteList(MapListBox.SelectedItem).MapName);
                     LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
		            }
               }
               SelectionTime = GetPlayerOwner().Level.TimeSeconds; // delays the selection to prevent laggy scolling due to screenshot loading
               break;

            case lstMapStatus:
               //log("DoubleClick lstMapStatus");
               MapListBox.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5) // prevent spamming
               {
	          if(Left(UMenuMapVoteList(MapListBox.SelectedItem).MapName,3) != "[X]" || GetPlayerOwner().PlayerReplicationInfo.bAdmin)
		  {
                     GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP "$UMenuMapVoteList(MapListBox.SelectedItem).MapName);
                     LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
		  }
               }
               SelectionTime = GetPlayerOwner().Level.TimeSeconds;
               break;

            case PlayerListBox:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5)
               {
                  GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE KICK "$PlayerVoteListItem(PlayerListBox.SelectedItem).PlayerName);
                  LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               }
               break;

            case lstKickStatus:
               PlayerListBox.SelectPlayer(KickStatusListItem(lstKickStatus.SelectedItem).PlayerName);
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5)
               {
                  GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE KICK X"$PlayerVoteListItem(PlayerListBox.SelectedItem).PlayerName);
                  LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               }
               break;
         }
         break;

      case DE_Click:
         switch(C)
         {
            case SendButton:
               if(txtMessage.GetValue() != "")
               {
                  GetPlayerOwner().ConsoleCommand("SAY "$ txtMessage.GetValue());
                  txtMessage.SetValue("");
               }
               break;

            case VoteButton:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5) // prevent spamming
               {
	          if(Left(UMenuMapVoteList(MapListBox.SelectedItem).MapName,3) != "[X]" || GetPlayerOwner().PlayerReplicationInfo.bAdmin)
		  {
                     if(UMenuMapVoteList(MapListBox.SelectedItem).MapName != "")
                        GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE MAP "$UMenuMapVoteList(MapListBox.SelectedItem).MapName);
                     LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
		  }
               }
               break;

            case InfoButton:
               if(MapListBox.SelectedItem != None)
               {
                  MapVoteTabWindow(ParentWindow.ParentWindow).InfoWindow.BrowseWebPage(MapVoteTabWindow(ParentWindow.ParentWindow).InfoWindow.MapInfoURL $ UMenuMapVoteList(MapListBox.SelectedItem).MapName $ ".htm");
                  MapVoteTabWindow(ParentWindow.ParentWindow).Pages.GotoTab(MapVoteTabWindow(ParentWindow.ParentWindow).Pages.GetPage("Info"), true);
               }
               break;

            case CloseButton:
               ParentWindow.ParentWindow.Close();
               break;

            case MapListBox:
               SelectionTime = GetPlayerOwner().Level.TimeSeconds; // delays the selection to prevent laggy scolling due to screenshot loading
               break;

            case lstMapStatus:
               MapListBox.SelectMap(MapStatusListItem(lstMapStatus.SelectedItem).MapName);
               SelectionTime = GetPlayerOwner().Level.TimeSeconds;
               break;

            case KickVoteButton:
               if(GetPlayerOwner().Level.TimeSeconds > LastVoteTime + 5) // prevent spamming
               {
                  GetPlayerOwner().ConsoleCommand("MUTATE BDBMAPVOTE KICK "$PlayerVoteListItem(PlayerListBox.SelectedItem).PlayerName);
                  LastVoteTime = GetPlayerOwner().Level.TimeSeconds;
               }
               break;

            case lstKickStatus:
               PlayerListBox.SelectPlayer(KickStatusListItem(lstKickStatus.SelectedItem).PlayerName);
               break;

         }
         break;

      case DE_EnterPressed:
         if(txtMessage.GetValue() != "")
         {
            GetPlayerOwner().ConsoleCommand("SAY "$ txtMessage.GetValue());
            txtMessage.SetValue("");
            txtMessage.FocusOtherWindow(SendButton);
         }
         break;
   }
}

function tick(float DeltaTime)
{
   if(SelectionTime != 0 && GetPlayerOwner().Level.TimeSeconds  > SelectionTime + 1)
   {
      SetMap(UMenuMapVoteList(MapListBox.SelectedItem).MapName);
      SelectionTime = 0;
   }
   super.tick(DeltaTime);
}

function SetMap(string MapName)
{
     local int i;
     local LevelSummary L;

     if(!cbLoadScreenShot.bChecked)
        return;

     i = InStr(Caps(MapName), ".UNR");
     if(i != -1)
          MapName = Left(MapName, i);

     if(PreFixSwap == "")  // no prefix swapping load as normal
     {
        if(Left(MapName,3) == "LMS" || Left(MapName,3) == "TDM")
	{
           Screenshot = Texture(DynamicLoadObject("DM" $ Mid(MapName,3) $ ".Screenshot", class'Texture'));
           L = LevelSummary(DynamicLoadObject("DM" $ Mid(MapName,3) $".LevelSummary", class'LevelSummary'));
	}
	else
	{
           Screenshot = Texture(DynamicLoadObject(MapName$".Screenshot", class'Texture'));
           L = LevelSummary(DynamicLoadObject(MapName$".LevelSummary", class'LevelSummary'));
	}
     }
     else
     {
        if(Left(MapName,Len(PreFixSwap)) == PreFixSwap) // this is a prefix swapped map
	{
           if(MapPreFixOverRide == "")  // Not Overridden map prefix, load default prefix
	   {
              Screenshot = Texture(DynamicLoadObject(OtherPreFix $ Mid(MapName,Len(PreFixSwap)) $ ".Screenshot", class'Texture'));
              L = LevelSummary(DynamicLoadObject(OtherPrefix $ Mid(MapName,Len(PreFixSwap)) $".LevelSummary", class'LevelSummary'));
	   }
	   else  // Overridden map prefix, load with Overridden map prefix
	   {
              Screenshot = Texture(DynamicLoadObject(MapPreFixOverRide $ Mid(MapName,Len(PreFixSwap)) $".Screenshot", class'Texture'));
              L = LevelSummary(DynamicLoadObject(MapPreFixOverRide $ Mid(MapName,Len(PreFixSwap)) $".LevelSummary", class'LevelSummary'));
	   }
        }
	else  // This is not a prefix swapped map , load as normal
	{
           if(Left(MapName,3) == "LMS" || Left(MapName,3) == "TDM")
	   {
              Screenshot = Texture(DynamicLoadObject("DM" $ Mid(MapName,3) $ ".Screenshot", class'Texture'));
              L = LevelSummary(DynamicLoadObject("DM" $ Mid(MapName,3) $".LevelSummary", class'LevelSummary'));
	   }
	   else
	   {
              Screenshot = Texture(DynamicLoadObject(MapName$".Screenshot", class'Texture'));
              L = LevelSummary(DynamicLoadObject(MapName$".LevelSummary", class'LevelSummary'));
	   }
	}
     }
     if(Left(MapName,3) == "[X]")
     {
        MapTitle = "You can NOT";
        MapAuthor = "vote for this map.";
        IdealPlayerCount = "";
     }
     else
     {
        if(L != None)
        {
           MapTitle = L.Title;
           MapAuthor = L.Author;
           IdealPlayerCount = L.IdealPlayerCount;
        }
        else
        {
           MapTitle = "DownLoad";
           MapAuthor = "Required";
           IdealPlayerCount = "";
        }
     }
}


function Paint(Canvas C, float MouseX, float MouseY)
{
     local int i,p1,p2,pos;
     local string TempText,TextLine;
     local float X, Y, W, H;

     Super.Paint(C,MouseX,MouseY);

     //DrawStretchedTexture(C, 145, 10, 120, 110, Texture'BlackTexture');

     DrawStretchedTexture(C, 0, 0, WinWidth, WinHeight, Texture'BlackTexture');

     if(Screenshot != None)
     {
          W = Min(100, Screenshot.USize);
          H = Min(100, Screenshot.VSize);
          if(W > H)
               W = H;
          if(H > W)
               H = W;
          C.DrawColor.R = 255;
          C.DrawColor.G = 255;
          C.DrawColor.B = 255;

          DrawStretchedTexture(C, 145, 10, 120, 110, Screenshot);
     }

     C.Font = Root.Fonts[F_Normal];

     if(IdealPlayerCount != "")
     {
        TextSize(C, IdealPlayerCount $ " Players", W, H);
        ClipText(C, 155, 110, IdealPlayerCount $ " Players");
     }

     if(MapAuthor != "")
     {
        TextSize(C, MapAuthor, W, H);
        ClipText(C, 155, 40, MapAuthor);
     }
          
     if(MapTitle != "")
     {
        TextSize(C, MapTitle, W, H);
        ClipText(C, 155, 20, MapTitle);
     }


     // Draw Status text
     C.DrawColor.R = 0;
     C.DrawColor.G = 0;
     C.DrawColor.B = 0;
     C.Font = Root.Fonts[F_Normal];
}

function KeyDown( int Key, float X, float Y )
{
   ParentWindow.KeyDown(Key,X,Y);
}


function Close(optional bool bByParent)
{
    local int w, Mode;

    class'BDBMapVote304.BDBMapVote'.default.bLoadScreenShot = cbLoadScreenShot.bChecked;
    class'BDBMapVote304.BDBMapVote'.static.StaticSaveConfig();
    Super.Close(bByParent);
}

defaultproperties
{
}
